/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item;

import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.client.render.RenderConfigs;
import dev.toma.gunsrpg.common.AnimationPaths;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.GrenadeEntity;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.item.BaseItem;
import dev.toma.gunsrpg.common.item.ICustomUseDuration;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.Animation;
import lib.toma.animations.api.IAnimationEntry;
import lib.toma.animations.api.IAnimationLoader;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.IRenderConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrenadeItem
extends BaseItem
implements IAnimationEntry,
ICustomUseDuration {
    private final int blastSize;
    private final boolean explodeOnImpact;

    public GrenadeItem(String name, int blastRadius, boolean explodeOnImpact) {
        super(name, new Item.Properties().func_200916_a(ModTabs.WEAPON_TAB).func_200917_a(10));
        this.blastSize = blastRadius;
        this.explodeOnImpact = explodeOnImpact;
    }

    public int func_77626_a(ItemStack stack) {
        return 45;
    }

    @Override
    public int getUseDuration(int defaultDuration, ItemStack stack, PlayerEntity player) {
        if (PlayerData.hasActiveSkill(player, Skills.GRENADIER)) {
            return (int)((double)defaultDuration * 0.7);
        }
        return defaultDuration;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity livingEntity) {
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new GrenadeEntity((EntityType<? extends GrenadeEntity>)((EntityType)ModEntities.GRENADE.get()), world, livingEntity, 80, this.blastSize, this.explodeOnImpact, itemStack.func_77973_b()));
            if (livingEntity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)livingEntity;
                if (!player.func_184812_l_()) {
                    itemStack.func_190918_g(1);
                }
                player.func_184811_cZ().func_185145_a((Item)this, 5);
            }
        }
        return itemStack;
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity entity, int timeLeft) {
        if (world.field_72995_K) {
            this.stopThrowAnimation();
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            this.startThrowAnimation();
        }
        player.func_184598_c(hand);
        return ActionResult.func_226250_c_((Object)stack);
    }

    @Override
    public IRenderConfig right() {
        return RenderConfigs.HEAL_CONFIG;
    }

    @Override
    public IRenderConfig left() {
        return RenderConfigs.HEAL_CONFIG;
    }

    @Override
    public boolean disableVanillaAnimations() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void stopThrowAnimation() {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        pipeline.remove(ModAnimations.GRENADE);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void startThrowAnimation() {
        AnimationEngine engine = AnimationEngine.get();
        IAnimationPipeline pipeline = engine.pipeline();
        IAnimationLoader loader = engine.loader();
        IKeyframeProvider provider = loader.getProvider(AnimationPaths.GRENADE);
        int originalDuration = this.func_77626_a(ItemStack.field_190927_a);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        pipeline.insert(ModAnimations.GRENADE, new Animation(provider, this.getUseDuration(originalDuration, ItemStack.field_190927_a, (PlayerEntity)player) - 2));
    }
}

